#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "setupdlg.h"
#include "qcap.h"
#include "qcap.windef.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    void HwInitialize();

    void HwUninitialize();

private:
    Ui::MainWindow *ui;

public:
    setupdlg        *m_setupdlg;

    /* DEVICE INFO */

    PVOID           m_hVideoDevice;

    QString         str_info;

    QString         path;

    ulong           m_nVideoInput;

    ulong           m_nAudioInput;

    /* VIDEO INFO */

    ulong           m_nVideoWidth;

    ulong           m_nVideoHeight;

    bool            m_bVideoIsInterleaved;

    double          m_dVideoFrameRate;

    /* AUDIO INFO */

    ulong           m_nAudioChannels;

    ulong           m_nAudioBitsPerSample;

    ulong           m_nAudioSampleFrequency;

    /* OTHER */

    BOOL			m_bSupportGPU1;

    BOOL			m_bSupportGPU2;

    BOOL			m_bSupportGPU3;

    BOOL			m_bMP4_11;

    BOOL			m_bMP4_12;

    BOOL			m_bMP4_13;

};

#endif // MAINWINDOW_H
